(define (find-order num-courses prerequisites)
  (let* ((graph (make-vector num-courses '()))
         (indegree (make-vector num-courses 0))
         (queue '())
         (result '()))
    (for ([prereq prerequisites])
      (let ((course (cadr prereq))
            (dependent (car prereq)))
        (vector-set! graph course (cons dependent (vector-ref graph course)))
        (vector-set! indegree dependent (+ (vector-ref indegree dependent) 1))))
    (for ([i (in-range num-courses)])
      (when (zero? (vector-ref indegree i))
        (set! queue (cons i queue))))
    (let loop ()
      (when (not (null? queue))
        (let ((current (car queue)))
          (set! queue (cdr queue))
          (set! result (cons current result))
          (for ([neighbor (vector-ref graph current)])
            (vector-set! indegree neighbor (- (vector-ref indegree neighbor) 1))
            (when (zero? (vector-ref indegree neighbor))
              (set! queue (cons neighbor queue))))
          (loop))))
    (if (= (length result) num-courses)
        (reverse result)
        '())))